/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Reflection;
using System.Windows.Forms;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Handles;
using Borland.Eco.WinForm;

namespace Borland.Eco.AutoContainers
{
	///<summary>
	///This class is replaced by Borland.Eco.AutoContainers.AutoContainerService.
	///Consider this class obsolete.
	///</summary>	
	public class AutoContainerProvider
	{
		private Control host;
		public Control Host
		{
			get { return host; }
		}
		///<exception cref="ArgumentNullException">Thrown if <paramref name="host"/> is null.</exception>
		public AutoContainerProvider(Control host, EcoSpace ecoSpace)
		{
			if (host == null) throw new ArgumentNullException("host"); // Do not localize
			this.EcoSpace = ecoSpace;
			this.host = host;
			TraverseControls(host.Controls);
		}
		private void DoubleClickHandler(object sender, System.EventArgs e)
		{
			if (EcoSpace == null)
				return;
			IElement element = CurrencyManagerHandle.CurrentElement(sender as Control);

			// Bring up auto container
			if (element != null)
			{
				AutoContainerArgs autoContainerArgs = new AutoContainerArgs(EcoSpace, false, AutoContainerMemberVisibility.AllMembers, ContainerReusage.NeverReuse, false);
				IAutoContainer a = AutoContainerService.Instance.CreateContainer(element, autoContainerArgs);
				a.Show(autoContainerArgs);
			}
		}
		private void HookupControl(Control control)
		{
			if (control == null) throw new ArgumentNullException("control"); // Do not localize
			control.DoubleClick += new System.EventHandler(this.DoubleClickHandler);
		}
		///<exception cref="ArgumentNullException">Thrown if <paramref name="control"/> is null.</exception>
		protected virtual bool IsHookable(Control control)
		{
			if (control == null) throw new ArgumentNullException("control"); // Do not localize
			return control.GetType().GetProperty(EcoWinFormHelper.PropertyNameDataSource) != null;
		}
		private void TraverseControls(Control.ControlCollection controls)
		{
			foreach (Control control in controls)
			{
				// Hook up controls
				if (IsHookable(control))
				{
					HookupControl(control);
				}
				// Span tree
				TraverseControls(control.Controls);
			}
		}
		private EcoSpace m_EcoSpace;
		public EcoSpace EcoSpace
		{
			get { return m_EcoSpace; }
			set { m_EcoSpace = value; }
		}
	}
}
